/* lexer.h - lexical analysis header file */

#define S_UNDEF -1
#define S_INT 0
#define S_EOE 1
#define S_EOF 2
#define S_STR 3
#define S_SYM 4
#define S_USTR 5 /* unterminated string */
#define S_GTEQ 6
#define S_LTEQ 7
#define S_NEQ 8
#define S_EQ 9

#define LEXTOKSIZ 72
#define LEXBUFSIZ 256

struct st_lex {
    int sym;
    char tok[LEXTOKSIZ+1];
};

extern struct st_lex lex;

struct st_lex lexer(void);
bool lex_match(char);
void lex_init(char *);
